/*
  libakai - C++ cross-platform akai sample disk reader
  Copyright (C) 2002-2003 Sbastien Mtrot

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
// DeviceAccessTest.cpp : Defines the entry point for the console application.
//

#ifdef _WIN32_
#define _WIN32_WINNT 0x0500

#include <windows.h>
#include <conio.h>
#endif

#include <stdio.h>
#include "DiskImage.h"
#include "AkaiDisk.h"

void PrintLastError(char* file, int line)
{
#ifdef _WIN32_
  LPVOID lpMsgBuf;
  FormatMessage( 
      FORMAT_MESSAGE_ALLOCATE_BUFFER | 
      FORMAT_MESSAGE_FROM_SYSTEM | 
      FORMAT_MESSAGE_IGNORE_INSERTS,
      NULL,
      GetLastError(),
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &lpMsgBuf,
      0,
      NULL 
  );

  // Display the string.
  char buf[2048];
  sprintf(buf,"%s(%d): %s",file, line, (LPCTSTR)lpMsgBuf);
  printf("%s",buf);
  OutputDebugString(buf);
  // Free the buffer.
  LocalFree( lpMsgBuf );
#endif
}

#define SHOWERROR PrintLastError(__FILE__,__LINE__)


int main(int argc, char** argv)
{
  char drive;
  char rootpath[4]="a:\\";
  int type;

  if (argc<3)
  {
    printf("DumpImage <drive letter>: <destination filename>\n");
    printf("by Sebastien Mtrot (meeloo@meeloo.net)\n");
    printf("\nType of your drives:\n");

#ifdef _WIN32_
    for (drive='a';drive<='z';drive++) 
    {
      rootpath[0]=drive;
      type=GetDriveType(rootpath);
      if (type != DRIVE_NO_ROOT_DIR)
      {
        printf("Drive %s is a ",rootpath);
        switch(type) 
        {
          case DRIVE_UNKNOWN: printf("Unknown\n"); break;
          case DRIVE_NO_ROOT_DIR: printf("Unavailable\n");
          case DRIVE_REMOVABLE: printf("removable disk\n"); break;
          case DRIVE_FIXED: printf("fixed disk\n"); break;
          case DRIVE_REMOTE: printf("remote (network) drive\n"); break;
          case DRIVE_CDROM: printf("CD-ROM drive\n"); break;
          case DRIVE_RAMDISK: printf("RAM disk\n"); break;
        }
      }
    }
#endif
    exit(0);
  }

  DiskImage* pImage;
  drive = toupper(*(argv[1]))-'A';
  printf("opening drive %c:\n",drive+'a'); 
  pImage = new DiskImage(drive);

  FILE* file = fopen(argv[2],"wb");

  if (!file)
  {
    printf("couldn't open file '%s'\n", argv[2]);
    exit(0);
  }

  uint i;
  uint size = pImage->Available(1);
  uint mbytes = 0;
  uint writenbytes = 0;
  printf("Dumping %d bytes (%d Mb)\n",size, size / (1024*1024)); 
  for (i=0; i<size; )
  {
    char buffer[2048];
    uint32 readbytes = 0;
    readbytes = pImage->Read(buffer, 2048, 1);
    writenbytes += fwrite(buffer, readbytes,1, file);
    i += readbytes;
    
    if (i / (1024*1024) > mbytes)
    {
      mbytes = i / (1024*1024);
      printf("\rDumped %d Mbytes.",mbytes);
    }
  }

  printf("\n%d bytes read, %d bytes written\nOK\n",i,writenbytes);

  fclose(file);

  delete pImage;

//  while(!_kbhit());
  return 0;
}

